using System;
using System.Drawing;
using System.Collections;
using System.Windows.Forms;
using System.Data;

using System.Drawing.Design;
using System.ComponentModel;
using System.ComponentModel.Design;
using System.Reflection;
using System.Runtime.Serialization;
using System.Windows.Forms.Design;
using Borland.Studio.ToolsAPI;
using System.Diagnostics;

namespace ToolsAPIAddIn
{
	/// <summary>
	/// Summary description for WinForm.
	/// </summary>
	[ToolboxItemAttribute(false)] // hide us.
	public class MainForm : System.Windows.Forms.Form
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.Button button1;
		private ToolsAPIAddIn.SampleComponent userControl1;

		public MainForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose (bool disposing)
		{
			if (disposing)
			{
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.button1 = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// button1
			// 
			this.button1.Location = new System.Drawing.Point(48, 128);
			this.button1.Name = "button1";
			this.button1.Size = new System.Drawing.Size(320, 23);
			this.button1.TabIndex = 0;
			this.button1.Text = "Install the above component into the IDE";
			this.button1.Click += new System.EventHandler(this.button1_Click);
			// 
			// MainForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(416, 187);
			this.Controls.Add(this.button1);
			this.Name = "MainForm";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "Tools API example";
			this.ResumeLayout(false);
		}
		#endregion


		// This code is similar to what the IDE uses
		public static ToolboxItem CreateItemFromType(Type t)
		{
			ToolboxItemAttribute itemAttribute = (ToolboxItemAttribute)TypeDescriptor.GetAttributes(t)[typeof(ToolboxItemAttribute)];
			Debug.Assert(itemAttribute != null);
			if (itemAttribute != null)
			{
				if (itemAttribute == ToolboxItemAttribute.None) 
				{
					return null;
				}
				ToolboxItem result = null;
				Type itemType = null;

				itemType = itemAttribute.ToolboxItemType;

				// Try the constructor with a type as the first param
				ConstructorInfo ci = itemType.GetConstructor(new Type[1] { typeof(Type) });
				if (ci != null)
				{
					result = (ToolboxItem)ci.Invoke(new object[1] { t });
				}
				else // Try the constructor with no parameters
				{
					ci = itemType.GetConstructor(new Type[0]);
					if (ci != null)
					{
						result = (ToolboxItem)ci.Invoke(new object[0]);
						result.Initialize(t);
					}
				}
				if (result == null)
					throw new Exception("No toolbox item");
				return result;
			}
			else
				throw new Exception("No toolbox item attribute");
		}

		private bool IsTypeSelectable(Type t)
		{
			if (t.IsPublic && !t.IsAbstract) 
			{
				if (typeof(IComponent).IsAssignableFrom(t)) 
				{
					ToolboxItemAttribute ta =
						(ToolboxItemAttribute)TypeDescriptor.GetAttributes(t)[typeof(ToolboxItemAttribute)];
					if (!ta.Equals(ToolboxItemAttribute.None)) 
					{
						return true;
					}
				}
			}
			return false;
		}

		private void button1_Click(object sender, System.EventArgs e)
		{
			IOTAComponentInstallService installService =
				(IOTAComponentInstallService)BorlandIDE.GetService(typeof(IOTAComponentInstallService));
			if (installService != null)
			{
				// Install all components in this assembly
				Assembly a = GetType().Assembly;
				AssemblyName asmName = a.GetName();
				foreach (Type t in a.GetTypes())
				{
					try
					{
						if (IsTypeSelectable(t))
						{
							// This dynamically creates the type.
							// You could manually create a ToolboxItem,
							// and properly set it up, if you wish.
							ToolboxItem toolboxItem = CreateItemFromType(t);
							if (toolboxItem != null)
							{
								toolboxItem.AssemblyName = asmName;
								installService.Add(toolboxItem, "My Cool Components");
							}
						}
					}
					catch (Exception ee)
					{
						System.Diagnostics.Debug.WriteLine(
							"Failed to create toolbox item for: " + t.ToString() +  // Do not localize
							" Error: " + ee.Message); // Do not localize
					}
				}
				installService.SaveState();
				MessageBox.Show("Cool, it worked!");
				Close();
			}
		}
	}
}
